// __multiversion__
// This signals the loading code to prepend either #version 100 or #version 300 es as apropriate.

#include "vertexVersionCentroid.h"
#if __VERSION__ >= 300
	#ifndef BYPASS_PIXEL_SHADER
		_centroid out vec2 uv0;
		_centroid out vec2 uv1;
	#endif
#else
	#ifndef BYPASS_PIXEL_SHADER
		out vec2 uv0;
		out vec2 uv1;
	#endif
#endif

#include "uniformWorldConstants.h"
#include "uniformPerFrameConstants.h"
#include "uniformShaderConstants.h"
#include "uniformRenderChunkConstants.h"
#include "lib/s_lib.h"

#ifndef BYPASS_PIXEL_SHADER
varying vec4 color;
#endif

varying hmp vec3 cpos;
varying hmp vec3 wpos;
varying float farrender;
varying float farchunk;

#ifdef UNDERWATER
varying float fogr;
#endif

attribute POS4 POSITION;
attribute vec4 COLOR;
attribute vec2 TEXCOORD_0;
attribute vec2 TEXCOORD_1;

const float rA = 1.0;
const float rB = 1.0;
const vec3 UNIT_Y = vec3(0,1,0);
const float DIST_DESATURATION = 56.0 / 255.0; //WARNING this value is also hardcoded in the water color, don'tchange

void main()
{
	POS4 worldPos;
///fixed cutoff chunk position by @McbeEringi
	POS3 wapos = vec3(POSITION.x==16.0 ? 0.0 : POSITION.x, abs(POSITION.y-8.0), POSITION.z==16.0 ? 0.0 : POSITION.z);
///
	hmp float wave = sin(TIME*4.+wapos.x+wapos.z+wapos.y)*hash(wapos.x+wapos.y+wapos.z);

#ifdef AS_ENTITY_RENDERER
		POS4 pos = WORLDVIEWPROJ * POSITION;
		worldPos = pos;
#else
	worldPos.xyz = (POSITION.xyz * CHUNK_ORIGIN_AND_SCALE.w) + CHUNK_ORIGIN_AND_SCALE.xyz;
	worldPos.w = 1.0;
#if !defined(SEASONS) && !defined(ALPHA_TEST)
if(COLOR.a < 0.95 && COLOR.a > 0.05)worldPos.y += wave*.1*fract(POSITION.y)*clamp(1.-farchunk,0.,1.);
#endif
	// Transform to view space before projection instead of all at once to avoid floating point errors
	// Not required for entities because they are already offset by camera translation before rendering
	// World position here is calculated above and can get huge
	POS4 pos = WORLDVIEW * worldPos;
	pos = PROJ * pos;
#endif
	gl_Position = pos;

#ifndef BYPASS_PIXEL_SHADER
	uv0 = TEXCOORD_0;
	uv1 = TEXCOORD_1;
	color = COLOR;
#endif
	cpos = POSITION.xyz;
	wpos = worldPos.xyz;
	farrender = length(worldPos.xyz)/RENDER_DISTANCE;
	farchunk = length(worldPos.xyz)/FAR_CHUNKS_DISTANCE;
	hmp float wave_factor = 0.0;
if(COLOR.a == 0.0){
	wave_factor = 0.2*clamp(1.-farchunk,0.,1.);
	wave_factor *= uv1.y;
}else{
#ifdef ALPHA_TEST
if(COLOR.g + COLOR.g > COLOR.b + COLOR.r){
	wave_factor = 0.2*clamp(1.-farchunk,0.,1.);
	wave_factor *= uv1.y;
}
#endif
}
#ifdef UNDERWATER
	wave_factor = 0.01*pow(pos.z,1.5);
#endif
if(wave_factor > 0.0){
	gl_Position.x += wave * (.1*sin(TIME)+.2) * wave_factor;
}

#ifdef UNDERWATER
	float len = length(-worldPos.xyz) / RENDER_DISTANCE;
	#ifdef ALLOW_FADE
		len += RENDER_CHUNK_FOG_ALPHA;
	#endif
	fogr = clamp((len - FOG_CONTROL.x) / (FOG_CONTROL.y - FOG_CONTROL.x), 0.0, 1.0);
#endif

}
